<?php 
require_once('connection/dbConfig.php');
require_once('include/functions.inc.php');

header('Content-Language: en');
header('Content-Type: text/html;charset=UTF-8');
header("Cache-Control: no-cache, must-revalidate");
header('Pragma', 'no-cache');
header('Expires', '0');
header('Content-type: application/json');

 ?>
<?php
session_start();

$return_arr = array();
$error_msg  = '';
$error_msgsrch  = '';
$affected_rows=0;	
if ($_POST['action'] == 'fill_record') {
    $stmt = $connAdmin->prepare("SELECT proctorid, name,date_format(dob,'%d/%m/%Y') as dob ,mobile,user_type FROM proctors WHERE autonum = ?");
	$stmt->bindValue(1, $_POST['autonum'], PDO::PARAM_INT);

	try {
		$stmt->execute();
		$rows = $stmt->fetch(PDO::FETCH_ASSOC);
		$affected_rows = $stmt->rowCount();
	} catch(PDOException $ex) {
		$error_msg  = $ex->getMessage();
	}

	$return_arr = array("affected_rows"=>$affected_rows,"proctorid"=>$rows['proctorid'],"name"=>$rows['name'],"dob"=>$rows['dob'],"mobile"=>$rows['mobile'],"user_type"=>$rows['user_type'],"error_msg"=>$error_msg);
	echo json_encode($return_arr);	
}else if ($_POST['action'] == 'create_newref') {
	
	$detailseq4	=	"";
	$stmt = $connAdmin->prepare("SELECT detailid FROM proctor_details WHERE  proctorid = ? order by insertdate desc limit 1");
	$stmt->bindValue(1, $_POST['proctorid'], PDO::PARAM_INT);	

	try {
		$stmt->execute();
		$rows = $stmt->fetch(PDO::FETCH_ASSOC);
		$affected_rows = $stmt->rowCount();
		$detailid = $rows['detailid'];
	} catch(PDOException $ex) {
		$error_msg  = $ex->getMessage();
	}
	
	if ($detailid != "0" ) {
	  $detailseq4= Get_NextSequence('trans_seq4', $connAdmin) ;
	  $stmt2 = $connAdmin->prepare("update proctor_details set modifydate = now(), detailseq4 = ? WHERE   detailid = ? ");
	  $stmt2->bindValue(1, $detailseq4         , PDO::PARAM_INT);
	  $stmt2->bindValue(2, $detailid , PDO::PARAM_INT);
 	try {
			$stmt2->execute();
			$affected_rows2 = $stmt2->rowCount();
		} catch(PDOException $ex) {
			$error_msg2  = $ex->getMessage();
		}
		
		
      $stmt2 = $connAdmin->prepare("update expyear set correct_id = ? WHERE ifnull(detailapproved4,False)=False and  proctorid = ? ");
	  $stmt2->bindValue(1, $detailseq4         , PDO::PARAM_INT);
	  $stmt2->bindValue(2, $_POST['proctorid'] , PDO::PARAM_INT);	  		
 	try {
			$stmt2->execute();
			$affected_rows2 = $stmt2->rowCount();
		} catch(PDOException $ex) {
			$error_msg2  = $ex->getMessage();
		}
		
		
	}
	
	$return_arr = array("affected_rows"=>$affected_rows,"error_msg"=>$error_msg,"detailseq4"=>$detailseq4,"error_msg2"=>$error_msg2);
	echo json_encode($return_arr);
		
}

else if ($_POST['action'] == 'add_teacher') {			
	$stmt_exist = $connAdmin->prepare("SELECT autonum from proctors where autonum= ? ");
	$stmt_exist->bindValue(1, $_POST['autonum'], PDO::PARAM_INT);
	try {					
		$stmt_exist->execute();
		$rows = $stmt_exist->fetch(PDO::FETCH_ASSOC);
		$affected_rows = $stmt_exist->rowCount();		
	} catch(PDOException $ex) {
		$error_msg  = $ex->getMessage();		
		
	}
    $error_msg ="الرقم الالي موجود سابقا";
	if ($rows['autonum']== 0) {
				
		$proctors_seq = Get_NextSequence('proctors_seq', $connAdmin);
		$stmt = $connAdmin->prepare(" INSERT INTO proctors (proctorid, autonum,  name,mobile,user_type,insertdate,dob)  ".								
									" VALUES (?, ?, ?,?,?,now(), ? ) ");
		$stmt->bindValue(1, $proctors_seq, PDO::PARAM_INT);
		$stmt->bindValue(2, $_POST['autonum'], PDO::PARAM_INT);
		$stmt->bindValue(3, $_POST['name'], PDO::PARAM_STR);
		$stmt->bindValue(4, $_POST['phone'], PDO::PARAM_INT);		
		
		
		if ($_POST['vRecordID'] == "1") {
			$stmt->bindValue(5, "ASSISTANT_IT", PDO::PARAM_STR);		
		}
		else {
		   $stmt->bindValue(5, "PROCTOR", PDO::PARAM_STR);		
		}
		
		$stmt->bindValue(6, insertMySQLDate($_POST['dob']), PDO::PARAM_STR);
				   
		try {
			$stmt->execute();
			$affected_rows = $stmt->rowCount();
		    $error_msg ="تمّت العملية بنجاح";	
		} catch(PDOException $ex) {
			$error_msg  = $ex->getMessage();
			$error_msg	= "Error on inserting into table proctors: " . $error_msg;				
			
		}
	} else {
		$stmt5 = $connAdmin->prepare(" update proctors set name = ? ,user_type = ? ,dob=? , mobile = ? ".								
									" where (user_type not in ('MEHE','ADMIN')) and  autonum = ? ");				
		$stmt5->bindValue(1, $_POST['name'], PDO::PARAM_STR);				
		if ($_POST['vRecordID'] == "1") {
			$stmt5->bindValue(2, "ASSISTANT_IT", PDO::PARAM_STR);		
		}
		else {
		   $stmt5->bindValue(2, "PROCTOR", PDO::PARAM_STR);		
		}		
		$stmt5->bindValue(3, insertMySQLDate($_POST['dob']), PDO::PARAM_STR);		
		$stmt5->bindValue(4, $_POST['phone'], PDO::PARAM_STR);		
		$stmt5->bindValue(5, $rows['autonum'] , PDO::PARAM_STR);						   
		try {
			$stmt5->execute();
			$affected_rows5 = $stmt5->rowCount();
		    $error_msg5 ="تمّت العملية بنجاح";	
			 $error_msg ="تمّت العملية بنجاح";	
		} catch(PDOException $ex) {
			$error_msg5  = $ex->getMessage();
			$error_msg5	= "Error on inserting into table proctors: " . $error_msg;				
			
		}
	}
	
	$return_arr = array("affected_rows"=>$affected_rows,"error_msg"=>$error_msg,"error_msg5"=>$error_msg5);
	echo json_encode($return_arr); 
	
}
?>